#!/usr/bin/perl

use warnings;
use strict;

use XML::LibXML;

sub dumpAttribs {
	my ( $node ) = @_;
	if ( $node->hasAttributes ) {
		foreach( $node->attributes ) {
			printf( " %10s: %-20s\n",
				$_->name,
				$_->value
			);
		}
	}
	print "\n";
}

my $parser = XML::LibXML->new();
my $doc = $parser->parse_string(<<EOT);
<?xml version="1.0"?>
<xml>
	Text im Dokument
	<element id="myID" name="myname" style="old" />
	Text kurz vorm Ende
	<object objid="001" objname="Object1" />
	<element id="002" name="myname2" />
</xml>
EOT

my $root  = $doc->documentElement();
my $xc    = XML::LibXML::XPathContext->new( $root );
my $nodes = $xc->findnodes( '/xml/element' );

foreach my $node ( $nodes->get_nodelist ) {
	print "Node: ",	$node->nodeName, "\n";
	dumpAttribs( $node );
}

