#!/usr/bin/perl

use warnings;
use strict;

use Switch;
use XML::LibXML;

my $parser = XML::LibXML->new();
my $doc = $parser->parse_string(
	'<?xml version="1.0"?><xml><!-- Kommentar -->Text im Dokument<element id="myID" name="myname" style="old" />Text kurz vorm Ende<object objid="001" objname="Object1" /></xml>'
);
my $root = $doc->documentElement();
print "Root: ", $root->nodeName, "\n";

switch( $ARGV[0] ) {
	case 'nodes' {
		foreach my $node ( $root->childNodes ) {
			print "Node: ", $node->nodeName, "\n";
		}
	}
	case 'attr' {
		foreach my $node ( $root->childNodes ) {
			print "Node: ", $node->nodeName, "\n";
			if ( $node->hasAttributes ) {
				foreach( $node->attributes ) {
					printf( " %10s: %-20s\n",
						$_->name,
						$_->value
					);
				}
			}
			print "\n";
		}
	}
}


