package MyHandler;
use base qw(XML::SAX::Base);

# Handler fuer Beginn eines Elements
sub start_element {
	my( $self, $element ) = @_;
	
	# object-Elemente filtern
	#if ( $element->{'LocalName'} eq 'object' ) {
		print "Element started: " . $element->{'LocalName'} . "\n";

		# Da $element->{'Attributes'} eine Hashreferenz ist,
		# hier dereferenzieren, um darueber zu iterieren
		foreach my $attr ( keys %{$element->{'Attributes'}} ) {
			printf(
				"%10s : [%s]\n",
				$element->{'Attributes'}->{$attr}->{'LocalName'},
				$element->{'Attributes'}->{$attr}->{'Value'}
			);
		}
		#}
	print "\n";
}

# Handler fuer Ende eines Elements
sub end_element {
	my( $self, $element ) = @_;
	print "Element closed: " . $element->{'LocalName'} . "\n";
}

# Handler fuer Zeichen (Elementinhalt)
sub characters {
	my( $self, $chars ) = @_;
	print "Characters:\n\t[", $chars->{'Data'}, "]\n\n";
}

1;
