#!/usr/bin/speedy -- -r10

use strict;
use warnings;
use DBI;
use CGI::SpeedyCGI;

use vars qw($dbh $counter);

my $sp = new CGI::SpeedyCGI;

print("Content-Type: text/html\n\n");

unless(defined($dbh) && $dbh->ping){
	$dbh = DBI->connect('dbi:SQLite:dbname=speedydbi.sqlite', '', '')
		|| do{
			print("Kann Datenbankverbindung nicht aufbauen.\n");
			$sp->shutdown_now;
		};
}

$sp->add_shutdown_handler(sub{
		$dbh->disconnect;
	});

$counter = defined($counter) ? $counter + 1 : 0;

$dbh->do('INSERT INTO zugriffe (pid, aufruf, aufrufer, zeitpunkt) '
	. 'VALUES (?, ?, ?, CURRENT_TIMESTAMP)', undef, ($$, $counter, $0));

print(<<'__EOF');
<html>
 <body>
  <table>
   <tr>
    <th>PID</th>
    <th>Aufruf Nr.</th>
    <th>Aufrufer</th>
    <th>Zeitpunkt</th>
   </tr>
__EOF

foreach my $row (@{$dbh->selectall_arrayref(
		'SELECT pid, aufruf, aufrufer, zeitpunkt ' .
		'FROM zugriffe ORDER BY id DESC LIMIT 20'
	)}){
	printf("   <tr>\n" . ("    <td>%s</td>\n" x 4) . "   </tr>\n", @{$row});
}

print(<<'__EOF');
  </table>
 </body>
</html>
__EOF
