#!/usr/bin/perl

use warnings;
use strict;

use Image::ObjectDetect;
use IO::Dir;
use File::Copy;

# Ab wie vielen Personen ist es eine Gruppe?
my $threshold = 3;

# Verzeichnis erzeugen fuer Gruppenbilder
mkdir "gruppenbilder" if ( ! -d "gruppenbilder" );

# Cascade-Datei fuer Gesichter, Frontalaufnahme
my $cascade = '/usr/share/opencv/haarcascades/haarcascade_frontalface_alt2.xml';

# Instanz erzeugen
my $detector = new Image::ObjectDetect( $cascade );

# Verzeichnis einlesen via IO::Dir
my $dir = IO::Dir->new( '.' );
if ( !defined ( $dir ) ) {
	die( 'Verzeichnis konnte nicht geoeffnet werden' );
}

while ( defined( $_ = $dir->read() ) ) {
	next if( /^\./ || -d $_ );
	my @faces = $detector->detect( $_ );

	# Bild kopieren bei Anzahl Gesichter groeßergleich Schwelle
	if ( scalar(@faces) >= $threshold ) {
		copy( $_, "gruppenbilder/$_" );
		print "Bild: $_ kopiert\n";
	}
}
