#!/usr/bin/perl

use warnings;
use strict;

use Image::ObjectDetect;
use IO::Dir;

# Cascade-Datei fuer Gesichter, Frontalaufnahme
my $cascade = '/usr/share/opencv/haarcascades/haarcascade_frontalface_alt2.xml';

# Instanz erzeugen
my $detector = new Image::ObjectDetect( $cascade );

# Verzeichnis einlesen via IO::Dir
my $dir = IO::Dir->new( '.' );
if ( !defined ( $dir ) ) {
	die( 'Verzeichnis konnte nicht geoeffnet werden' );
}

while ( defined( $_ = $dir->read() ) ) {
	next if( /^\./ || -d $_ );
	my @faces = $detector->detect( $_ );

	my $i=0;
	print "Bild: $_\n";
	foreach my $face (@faces) {
		my( $x, $y, $w, $h ) = (
		$face->{x},
		$face->{y},
		$face->{width},
		$face->{height}
		);

		printf(
		"\t#%02d: Pos: % 4d, % 4d / Dim: % 4d by % 4d\n",
		++$i, $x, $y, $w, $h
		);
	}
}
