#!/usr/bin/perl

use warnings;
use strict;

use Image::ObjectDetect;

if ( @ARGV < 1 ) {
	die( 'Kein Bild angegeben' );
}

# Cascade-Datei fuer Gesichter, Frontalaufnahme
my $cascade = '/usr/share/opencv/haarcascades/haarcascade_frontalface_alt2.xml';

# Instanz erzeugen
my $detector = new Image::ObjectDetect( $cascade );

# Erkannte Objekte (hier Gesichter) zurueckgeben
my @faces = $detector->detect( $ARGV[0] );

# Anzahl erkannter Objekte ausgeben
print 'Erkannte Objekte: ' . scalar( @faces ) . "\n";

