#!/usr/bin/perl

use warnings;
use strict;

use Image::ObjectDetect;
use Image::Magick;
use IO::Dir;


# Cascade-Datei fuer Gesichter, Frontalaufnahme
my $cascade = '/usr/share/opencv/haarcascades/haarcascade_frontalface_alt.xml';

# Instanz erzeugen
my $detector = new Image::ObjectDetect( $cascade );

# Verzeichnis erzeugen fuer markierte Bilder
my $outDir = "gesichter";
mkdir $outDir if ( ! -d $outDir );

# Verzeichnis einlesen via IO::Dir
my $dir = IO::Dir->new( '.' );
if ( !defined ( $dir ) ) {
	die( 'Verzeichnis konnte nicht geoeffnet werden' );
}

my $i=0;
while ( defined( $_ = $dir->read() ) ) {
	next if( /^\./ || -d $_ );
	my @faces = $detector->detect( $_ );

	print "Bild: $_\n";
	foreach my $face (@faces) {
		my $IM = Image::Magick->new;
		$IM->Read( $_ );
		my( $x, $y, $w, $h ) = (
			$face->{x},
			$face->{y},
			$face->{width},
			$face->{height}
		);

		my $croppedFace = $IM->Crop(
			geometry => $w.'x'.$h.'+'.$x.'+'.$y
		);

		$IM->Write( "$outDir/".(++$i)."-".$_ );
	}
	print "\tObjekte extrahiert: " . scalar(@faces) . "\n";
}
