#!/usr/bin/perl

use warnings;
use strict;

use Image::ObjectDetect;
use Image::Magick;
use IO::Dir;


# Cascade-Datei fuer Gesichter, Frontalaufnahme
my $cascade = '/usr/share/opencv/haarcascades/haarcascade_frontalface_alt2.xml';

# Instanz erzeugen
my $detector = new Image::ObjectDetect( $cascade );

# Verzeichnis erzeugen fuer markierte Bilder
my $markedDir = "markiert";
mkdir $markedDir if ( ! -d $markedDir );

# Verzeichnis einlesen via IO::Dir
my $dir = IO::Dir->new( '.' );
if ( !defined ( $dir ) ) {
	die( 'Verzeichnis konnte nicht geoeffnet werden' );
}

my $i=0;
while ( defined( $_ = $dir->read() ) ) {
	next if( /^\./ || -d $_ );

	# ImageMagick-Instanz
	my $IM = Image::Magick->new;

	my $targetImage = "$markedDir/$_";
	my @faces = $detector->detect( $_ );

	print "Bild: $_\n";
	$IM->Read( $_ );
	foreach my $face (@faces) {
		my( $x, $y, $w, $h ) = (
			$face->{x},
			$face->{y},
			$face->{width},
			$face->{height}
		);

		$IM->Draw(
		primitive	=> 'rectangle',
		points		=> "$x,$y ".($x+$w).','.($y+$h),
		stroke		=> 'red',
		strokewidth	=> 2,
		antialias	=> 1,
		fillcolor	=> 'rgba(100%,100%,0%,0.3)'
		);
		printf(
		"\t#%02d: Pos: % 4d, % 4d / Dim: % 4d by % 4d\n",
		++$i, $x, $y, $w, $h
		);
	}
	$IM->Write( $targetImage );
	print "\tObjekte markiert: " . scalar(@faces) . "\n";
	undef $IM;
}
