#!/usr/bin/perl

use strict;
use warnings;

# Zerlege eine Threshold-Range in Typ (innerhalb/ausserhalb des Bereichs) sowie
# untere und obere Schwelle, sofern definiert.
sub parseThreshold($){
	my($range) = @_;
	
	# Zerlege Schwellwerte/Bereiche per Regex in Type, Min und Max.
	my($type, $min, $max) = ($range =~ /^(@|)(?:(-?\d+(?:\.\d+)?|~):)?(-?\d+(?:\.\d+)?)?$/);
	
	# Gebe undef zurueck, falls Parsen nicht erfolgreich (durch ungueltiges
	# Format).
	return(undef) unless(defined($type));
	
	# $type ist 0 fuer Alarm falls ausserhalb des Bereichs und 1 fuer Alarm falls
	# innerhalb.
	$type = $type ne '' ? 1 : 0;

	# $min/$max soll undef sein falls keine untere/obere Schwelle definiert.
	$min = defined($min) ? ($min eq '~' ? undef : $min) : 0;
	
	# Pruefe, ob $min > $max ist und vertausche ggf. $min und $max.
	($min, $max) = ($max, $min) if(defined($min) && defined($max) && $min > $max);
	
	return($type, $min, $max);
}

print(join(', ', map{defined($_) ? $_ : 'undef'} parseThreshold($ARGV[0])) . "\n");
