#!/usr/bin/perl

# Dieses Plugin kann mit ePN ausgefuehrt werden.
# nagios: +epn

use strict;
use warnings;

use Getopt::Long;

sub main(){
	# Befehlszeile parsen, Warn-Schwelle in $warn und kritische Schwelle in
	# $crit speichern.
	new Getopt::Long::Parser(config => ['no_ignore_case', 'bundling'])
  	->getoptions('warning|w=i' => \my $warn, 'critical|c=i' => \my $crit)
	  	|| do{
					print("UNKNOWN : Unable to parse arguments!\n");
					exit(3);
				};
	
	# ACPI-Thermalzone 0 oeffnen...
	open(my $fd, '<', '/proc/acpi/thermal_zone/TZ00/temperature')
  	|| do{
				print("UNKNOWN : Unable to open ACPI thermal zone 0!\n");
				exit(3);
			};
	# ... und Wert sowie Einheit in $temp und $unit speichern.
	my($temp, $unit) = map{/^temperature:\s+(\d+)\s*(.*)$/ ? ($1, $2) : ()} <$fd>;
	close($fd);
	
	# Auf gueltigen Wert pruefen und mit kritischer und Warn-Schwelle vergleichen.
	if(!defined($temp)){
		print("UNKNOWN : Unable to collect temperature!\n");
		exit(3);
	}
	elsif(defined($crit) && $temp > $crit){
		printf("CRITICAL : Temperature %d %s (> %d)\n", $temp, $unit, $crit);
		exit(2);
	}
	elsif(defined($warn) && $temp > $warn){
		printf("WARNING : Temperature %d %s (> %d)\n", $temp, $unit, $warn);
		exit(1);
	}
	else{
		printf("OK : Temperature %d %s\n", $temp, $unit);
		exit(0);
	}
}

main();
1;