#!/usr/bin/perl

use warnings;
use strict;
no strict qw(refs);

sub introspect($){
	my($pkg) = @_;

	my $base = $pkg . '::';
	my %stash = %{$base};
	my @stash_keys = sort keys %stash;
	
	printf "%s: Global deklarierte, definierte Skalare: %s\n",
		$pkg, join ', ', grep{defined ${$base . $_}} @stash_keys;
	
	printf "%s: Global deklarierte, nicht leere Arrays: %s\n",
		$pkg, join ', ', grep{@{$base . $_}} @stash_keys;
	
	printf "%s: Global deklarierte, nicht leere Hashs: %s\n",
		$pkg, join ', ', grep{%{$base . $_}} @stash_keys;
	
	printf "%s: Globale Subs: %s\n",
		$pkg, join ', ', grep{defined &{$base . $_}} @stash_keys;
}

use Digest::MD5;
use Beispiel;

introspect('Beispiel');
introspect('Digest::MD5');
