package Introspector;

use strict;
use warnings;

use Carp;


# $AUTOLOAD muss ein Package-Global sein, es wird spaeter verwendet in
# sub AUTOLOAD{}.
use vars qw($AUTOLOAD);


# Konstruktor "new", akzeptiert hier keine Parameter.
sub new($){
	my($class) = @_;

	# Wir speichern die Attribute direkt im Hash des Objekts, ihre Typen
	# jedoch im unter _types referenzierten Hash.
	my $self = {
			_types => {}
		};

	# Strikte Refernzen muessen fuer den Zugriff auf den Stash ueber $class
	# deaktiviert werden.
	no strict qw(refs);
	# Aus dem Stash von $class suchen wir alle skalar deklarierten und
	# definierten Variablen...
	# FIXME: Wie koennen wir hier *alle* skalar deklarierten Variablen finden,
	# statt nur der definierten?
	my @scalar_attrs = grep{defined ${"${class}::$_"}} keys %{"${class}::"};

	# ... und iterieren ueber alle gefundenen.
	foreach my $attr (@scalar_attrs){

		# Wir beachten nur solche Variablennamen, die dem gewuenschten Muster
		# "{typ}_{name}" entsprechen.
		if(my($type, $name) = ($attr =~ /^([a-z][a-z0-9]*)_([a-zA-Z]\w*)$/)){

			# Attribute werden unabhaengig von ihrer Gross-/Kleinschreibung
			# betrachtet.
			$name = lc $name;
			# Der Wert der globalen Variable ist der Default-Wert und wird initial
			# unter dem Namen des Attributs hinterlegt.
			# Der Platzhalter "undef" dient dazu, Attribute initial nicht
			# definiert zu speichern.
			$self->{$name}
				= ${"${class}::$attr"} eq 'undef' ? undef : ${"${class}::$attr"};
			# Den zugehoerigen Typen speichern wir unter dem Namen des Attributs
			# im Hash unter _types.
			$self->{_types}->{$name} = $type;
		}	
	}
	
	bless $self, $class;
	return $self;
}


# Die Funktion AUTOLOAD() wird automatisch aufgerufen, wenn keine Funktion
# mit dem gesuchten Namen existiert.
sub AUTOLOAD{
	my($self, @args) = @_;

	# Der Name der urspruenglich gesuchten Funktion steht in der globalen
	# Variable $AUTOLOAD.
	# Wir verwerfen den normalerweise vorhandenen Paketnamen.
	(my $method = $AUTOLOAD) =~ s/^.*:://;

	# Zurueck gehen, falls die Funktion DESTROY gesucht wurde.
	return if($method eq 'DESTROY');

	# Beziehe die Klasse des Objekts. Abbrechen, falls kein Klassenname
	# gesetzt ist (d.h. die Funktion nicht als Methode eines Objekts
	# aufgerufen).
	my $class = ref $self
		|| croak "Function $method does not exist";

	# Spalte den Methodennamen auf in Typ (Setter-/Getter-Methode) und
	# Attributnamen auf.
	my($action, $attr) = ($method =~ /^(set|get)_?([a-z0-9]\w*)$/i);
	# Breche ab, falls der Methodenname nicht dem Muster entspricht oder das
	# Attribut nicht existiert.
	defined $attr && exists $self->{$attr = lc $attr}
		|| croak "Method $method does not exist in $class";

	# Wenn Methode ist ein Setter ist, ...
	if($action eq 'set'){
	
		my $retval;
		no strict qw(refs);

		# ... uebergebe die Funktionsparameter an die Parse-Funktion
		# (parse_{typ}()) des Attribut-Typs.
		# Fange Exceptions ab fuer den Fall, dass die Parse-Funktion nicht
		# existiert oder sie die Verarbeitung abbricht (z.B. ungueltige
		# Eingabedaten).
		eval{
			my $parser = 'parse_' . $self->{_types}->{$attr};
			$retval = $self->$parser(@args);
			1;
		} || do {
			# Abbrechen, falls das Attribut nicht gesetzt werden konnte
			# -- alternativ koennte hier auch undef zurueck gegeben werden.
			croak "Error setting attribute '$attr': $@";
		};
		# Da die Parse-Funktion erfolgreich war, setze ihren Rueckgabewert als
		# neuen Wert des Attributs.
		$self->{$attr} = $retval;
		
		# Gebe das Objekt zurueck -- alternativ koennte auch der Attribut-Wert
		# zurueckgegeben werden.
		return $self;
	}

	# Sonst ist sie ein Getter ...
	else{
		# ... und gibt einfach den aktuellen Wert des Attributs zurueck.
		return $self->{$attr};
	}
}

# Parse-Methode fuer int-Attribute; der Wert wird explizit in int gecastet.
sub parse_int($$){
	return int $_[1];
}

# Parse-Methode fuer word-Attribute; abbrechen, falls der Wert Zeichen
# enthaelt, die nicht aus der Klasse [0-9a-zA-Z] sind.
sub parse_word($$){
	die "Only 'word' characters [0-9a-zA-Z_] allowed.\n"
		unless(defined $_[1] && $_[1] !~ /\W/s);
	return $_[1];
}

# Parse-Methode fuer any-Attribute; akzeptiere unveraendert alle Werte.
sub parse_any($$){
	return $_[1];
}

1;