#!/usr/bin/perl

use strict;
use warnings;
use Image::Magick::Thumbnail::PDF qw(create_thumbnail);

print(<<__EOF);
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
	<head>
		<title>Index der PDF-Dateien</title>
	</head>
	<body>
		<h1>Index der PDF-Dateien</h1>
		<p>
__EOF

foreach(glob('*.pdf')){
	create_thumbnail(
			$_,
			$_.'.png',
			1,
			{
				restriction => 150,
				frame       => 1,
				normalize   => 0
			}
		);
	print(<<__EOF);
			<a href="$_"><img src="$_.png" alt="$_" title="$_" border="0" /></a>
__EOF
}

print(<<__EOF);
		</p>
	</body>
</html>
__EOF

