#!/usr/bin/perl

use strict;
use warnings;
use Image::Magick::Thumbnail::PDF qw(create_thumbnail);

my $file='regexp.pdf';

my $shots=create_thumbnail(
		$file,
		'all_pages',
		{
			restriction => 800,
			frame => 1,
			normalize => 0
		}
	);

print(<<__EOF);
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
	<head>
		<title>$file</title>
	</head>
	<body>
		<h1>$file</h1>
		<p>
__EOF

print(<<__EOF) foreach(@{$shots});
			<img src="$_" alt="$_" />
__EOF

print(<<__EOF);
		</p>
	</body>
</html>
__EOF
