#!/usr/bin/perl
#
# tv-opt.pl
# Erzeugt aus Bildern im Eingabeverzeichnis skalierte Bilder im Ausgabe-
# verzeichnis, die einen schwarzen Mindestrand besitzen, damit bei der Ausgabe
# auf Fernsehern (ueber DVD-Player o.ae.) keine Bildteile abgeschnitten werden.
#
# Ein Beispiel zum Vortrag "Bildverarbeitung mit PerlMagick" der Ruhr.pm,
# gehalten von Veit Wahlich, (C)2008.
#

use strict;
use warnings;
use Image::Magick;

my $dir_in           = 'input';         # Verzeichnis mit Eingabe-Bildern.
my $dir_out          = 'output';        # Verzwichnis fuer Ausgabe.
my $groesse_leinwand = '800x600';       # Groesse der Ausgabebilder.
my $groesse_bild     = '768x576';       # Groesse der eingebetteten Bilder.
my $qualitaet        = 85;              # Ausgabequalitaet/-kompression.

# Lese alle Eintraege aus dem Eingabeverzeichnis und filtere dabei nur
# normale Dateien heraus, die ausserdem nur alphanumerische Zeichen (plus "_")
# enthalten und die Endung .jpg, .jpeg oder .png tragen.
opendir(my $dh, $dir_in);
my @bilder = grep{-f $dir_in.'/'.$_ && /^\w+\.(?:jpe?g|png)$/i}readdir($dh);
closedir($dh);

# Durchlaufe alle Bilder und verarbeite sie.
foreach my $datei (@bilder){

	printf("Verarbeite %s...\n", $datei);

	# Erzeuge ein neues Image::Magick-Objekt $i, setze die Leinwandgroesse und
	# "lese" eine schwarze Flaeche hinein.
	my $i = new Image::Magick;
	$i->Set(size => $groesse_leinwand);
	$i->Read('xc:black');

	# Erzeuge ein weiteres Image::Magick-Objekt $j, lade die Eingabedatei hinein
	# und skaliere das Bild auf die maximale Bildgroesse herunter.
	my $j = new Image::Magick;
	$j->Read($dir_in.'/'.$datei);
	$j->Scale(geometry => $groesse_bild);

	# Lege das Bild $j zentriert ueber die schwarze Leinwand in $i.
	$i->Composite(
			image   => $j,
			gravity => 'Center'
		);

	# Schreibe das zusammengefuegte Bild in das Ausgabe-Verzeichnis.
	$i->Write(
			filename => $dir_out.'/'.$datei,
			quality  => $qualitaet
		);

}
