#!/usr/bin/perl
# 
# psycho-lama.pl
# Generiert aus fiesen Bildern noch fiesere Animationen.
# 
# Ein Beispiel zum Vortrag "Bildverarbeitung mit PerlMagick" der Ruhr.pm, 
# gehalten von Veit Wahlich, (C)2008.
# 

use strict;
use warnings;
use Image::Magick;

my $conf = {
		input  => 'lama.png',               # Mache aus dem Lama...
		output => 'psycho-lama.gif',        # ... ein fieses Psycho-Lama!
		rotate => -2.5,                     # Bild um -2.5° drehen...
		zoom   => 1.10,                     # ... und um 10% vergroessern.
		delay  => 5                         # 50ms Pause zwischen den Bildern.
	};

my $i = new Image::Magick;

# 4x das Eingabe-Bild in Ebenen laden.
$i->Read(map{$conf->{input}}(0..3));

# Breite und Hoehe der Ebene 0 als Referenz bestimmen.
my($w,$h) = $i->[0]->Get('width','height');

# Das Bild auf Ebene 0, $i->[0], bleibt unveraendert, aber...

# ... die Ebenen 1 und 3 werden etwas gedreht und vergroessert, ...
for(1,3){
	$i->[$_]->Rotate(degrees => $conf->{rotate});
	$i->[$_]->Scale(
			width  => $w*$conf->{zoom},
			height => $h*$conf->{zoom}
		);
}

# ... und die Ebenen 2 und 3 in ein Negativ verwandelt.
for(2,3){
	$i->[$_]->Negate();
}

# Die Ebene 1 und 3 muessen nach der Vergroesserung und Rotation wieder
# auf normale Groesse gebracht werden.

# Bestimme dafuer die Groessen-Differenz zwischen der Groesse der Ebene 1
# und der Referenzgroesse.
my($dx,$dy) = $i->[1]->Get('width','height');
$dx -= $w;
$dy -= $h;

# Beschneide die Ebenen 1 und 3 auf die Groesse des Originalbildes,
# die linke obere Ecke entspricht dabei der halben Groessen-Differenz.
for(1,3){
	$i->[$_]->Crop(
			width  => $w,
			height => $h,
			x      => $dx/2,
			y      => $dy/2
		);
}

# Die virtuelle linke obere Ecke aller Ebenen wird in die absolute obere linke
# Ecke gesetzt und die Zeitspanne zwischen den Bildwechseln wird gesetzt.
for(0..3){
	$i->[$_]->Set(
			page  => '+0+0',
			delay => $conf->{delay}
		);
}

# Nun muss nur noch die fertige Animation gespeichert werden.
$i->Write($conf->{output});

# Schliesslich wird die fertige Animation noch auf dem Bildschirm angezeigt.
$i->Animate();