#!/usr/bin/perl
#
# indexprint.pl
# Erzeugt einen Indexprint, wie er z.B. von Kontaktabzuegen in der
# Fotoentwicklung bekannt ist.
#
# Ein Beispiel zum Vortrag "Bildverarbeitung mit PerlMagick" der Ruhr.pm,
# gehalten von Veit Wahlich, (C)2008.
#

use strict;
use warnings;
use Image::Magick;

my $maske   = 'bilder/*.jpg';           # Dateimaske fuer Eingabe-Bilder.
my $index   = 'indexprint.jpg';         # Dateiname fuer die Ausgabedatei.
my $groesse = '120x120';                # Max. Groesse der Thumbnails.
my $spalten = 4;                        # Anzahl Bilder pro Zeile.

# Lese anhand der Dateimaske die Dateinamen der Bilder ein.
my @bilder = glob($maske);

# Jede Zeile soll $spalten Bilder enthalten, bestimme die Anzahl der Zeilen.
# Berechne Ganzzahl des Quotienten aus der Anzahl der Bilder durch die Anzahl
# der Spalten und addiere 1, falls die Division einen Rest enthaelt.
my $zeilen = int(@bilder / $spalten) + (@bilder % $spalten ? 1 : 0);

# Erzeuge in $i ein neues Image::Magick-Objekt.
my $i = new Image::Magick;

# Lese alle Bilder als Ebenen in $i ein.
$i->Read(@bilder);

# Entferne alle Pfadangaben aus den Dateinamen.
map{s|^.*/||}@bilder;

# Durchlaufe alle Bilder und gebe jedem Bild seinen Dateinamen als Label.
foreach my $j (@{$i}){
	$j->Label(shift(@bilder));
}

# Erstelle aus den Ebenen in $i einen Indexprint in einem neuen
# Image::Magick-Objekt $k.
my $k = $i->Montage(
		title      => $maske,               # Ueberschrift fuer den Indexprint.
		tile       => $spalten.'x'.$zeilen, # Anordnung der Einzelbilder.
		geometry   => $groesse.'+10+10',    # Max. Groesse und Abstand der Bilder.
		border     => 2,                    # Einen 2px breiten Rand um die Bilder.
		shadow     => 1,                    # Schatten fuer die Bilder.
		background => '#ffffff',            # Hintergrundfarbe fuer den Indexprint.
		fill       => '#000000',            # Vordergrundfarbe fuer Beschriftung.
		font       => 'Nimbus Sans L',      # Scrhift fuer die Beschriftung.
		pointsize  => 14                    # Referenz-Schriftgroesse.
	);

# Schreibe den Indexprint in eine Grafikdatei.
$k->Write(
		filename => $index,                 # Dateiname der Ausgabegrafik.
		quality  => 90                      # Qualitaets-/Kompressionsstufe.
	);

# Zeige den Indexprint auf dem Bildschirm an.
$k->Display();
