####################################################
# Filter::VariableModifiers                        #
####################################################
# Implementiert Praeprozessor-Modifikatoren fuer   #
# String-Skalare. "$<a" gibt "$a" rueckwaerts aus, #
# "$/a" entfernt Whitespace vom Anfang und Ende    #
# eines Strings, "$=a" entspricht "$a" mit         #
# Kapitaelchen, "$^a" ist "$a" in Grossschrift und #
# "$_a" entspricht "$a" in Kleinschrift. Alle      #
# Modifikatoren sind frei kombinierbar.            #
####################################################
# (C)2008 Veit Wahlich, Perl Mongers im Ruhrgebiet #
####################################################

package Filter::VariableModifiers;
use Filter::Simple;

FILTER_ONLY(code_no_comments => \&modifiers);

sub modifiers{
	s/\$([<\/=\^_]+)(?=\w)/insertCalls($1).'$'/ge;
	return($_);
}

sub insertCalls($){
	my($mods) = @_;
	my $calls = '';
	foreach(reverse(split(//, $mods))){
		if    (/</)  { $calls .= 'Filter::VariableModifiers::reverseString ' }
		elsif (/\//) { $calls .= 'Filter::VariableModifiers::truncateString ' }
		elsif (/=/)  { $calls .= 'Filter::VariableModifiers::capitalizeString ' }
		elsif (/\^/) { $calls .= 'uc ' }
		elsif (/_/)  { $calls .= 'lc ' }
	}
	return($calls);
}

sub reverseString($){
	return(join('', reverse(split(//, $_[0]))));
}

sub truncateString($){
	($_) = @_;
	s/^\s+//s;
	s/\s+$//s;
	return($_);
}

sub capitalizeString($){
	($_) = @_;
	s/(^|\s)(\w)/(defined($1)?$1:'').uc($2)/ge;
	return($_);
}
