package MyWebApp::Model::MyDataModel;

use strict;
use base 'Catalyst::Model::DBI';
use Data::Dumper;

__PACKAGE__->config(
    dsn           => 'dbi:Pg:dbname=yasn',
    user          => '',
    password      => '',
    options       => { RaiseError => 1 },
);

=head1 NAME

MyWebApp::Model::MyDataModel - DBI Model Class

=head1 SYNOPSIS

See L<MyWebApp>

=head1 DESCRIPTION

DBI Model Class.

=head1 AUTHOR

Simon A. Wilper

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

sub count_users {
	my( $self ) = @_;
	my $dbh = $self->dbh;

	my $rows = $dbh->selectall_arrayref(
		'SELECT COUNT(id) FROM users'
	);

	return $rows->[0]->[0];
}

sub simple_list {
	my( $self ) = @_;
	my $dbh = $self->dbh;

	return $dbh->selectall_hashref(
		'SELECT * FROM users', 'id'
	);
}

sub addNewUser {
	my( $self, $form ) = @_;
	my $dbh = $self->dbh;

	my @values;
	push( @values, $form->field('nick') );
	push( @values, $form->field('firstname') );
	push( @values, $form->field('lastname') );
	push( @values, ($form->field('gender') eq 'Male' ? 'm' : 'f' ) );
	push( @values, $form->field('password1') );
	push( @values, $form->field('email') );

	my $sth = $dbh->prepare(
		'INSERT INTO users( nick,firstname,lastname,gender,password,email ) VALUES( ?,?,?,?,?,? )'
	);

	return $sth->execute( @values );
}

1;
