package MyWebApp::Controller::Welcome;

use strict;
use warnings;
use parent qw/Catalyst::Controller::FormBuilder/;

=head1 NAME

MyWebApp::Controller::Welcome - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index :Local {
    my ( $self, $c, @args ) = @_;

	$c->stash->{title} = 'Willkommen';
	$c->stash->{message} = 'Hallo Welt. $args[0]: ' . $args[0];

	$c->stash->{params} = $c->request->parameters;

	$c->stash->{template} = 'welcome.tt';
}

sub users :Global {
	my ( $self, $c ) = @_;

	$c->stash->{template} = 'userlist.tt';

	$c->stash->{usercount} = $c->model('MyDataModel')->count_users();
	$c->stash->{users} = $c->model('MyDataModel')->simple_list();
}

sub add :Global Form {
	my ( $self, $c ) = @_;

	my $form = $self->formbuilder;

	if ( $form->submitted && $form->validate ) {
		my $rc = $c->model('MyDataModel')->addNewUser( $form );
		$c->response->body( 'RC: '. $rc );
	}
}


=head1 AUTHOR

Simon A. Wilper

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
